//	WindowHeader.h

#ifndef _H_WindowHeader
#define	_H_WindowHeader

#include "CFinderWindow.h"

#define	ADFS_HeaderHeight_INFO		21
#define	ADFS_HeaderHeight_STAT		21

/*************************************************************/
typedef enum {
	ADFS_ViewAs_ILLEGAL = -1, 
	
	ADFS_ViewAs_ICONS, 
	ADFS_ViewAs_LIST,
	ADFS_ViewAs_COLUMNS,
	
	ADFS_ViewAs_NUMTYPES
} ADFS_ViewAsType;

ADFS_ViewAsType	ADFS_CommandToViewAs(ulong command);
ulong			ADFS_ViewAsToCommand(ADFS_ViewAsType statType);

typedef enum {
	ADFS_Stat_ILLEGAL = -1, 
	
	ADFS_Stat_NONE, 
	
	ADFS_Stat_TWIRLIE, 
	ADFS_Stat_INDEX, 
	ADFS_Stat_ICON, 
	ADFS_Stat_NAME, 
	ADFS_Stat_SIZE, 	//	physical size
	ADFS_Stat_USED, 	//	logical size
	ADFS_Stat_KIND, 
	ADFS_Stat_CRE_DATE, 
	ADFS_Stat_MOD_DATE, 
	ADFS_Stat_LOCK, 
	
	ADFS_Stat_NUMTYPES
} ADFS_StatType;

ADFS_StatType	ADFS_CommandToStat(ulong command);
ulong			ADFS_StatToCommand(ADFS_StatType statType);

#define	ADFS_Stat_INC(_stat)	(ADFS_StatType)((_stat) + 1)
#define	ADFS_Stat_DEC(_stat)	(ADFS_StatType)((_stat) - 1)
#define	ADFS_Stat_FIRST_ONE		ADFS_Stat_INC(ADFS_Stat_NONE)
#define	ADFS_Stat_LAST_ONE		ADFS_Stat_DEC(ADFS_Stat_NUMTYPES)

#define	ADFS_Stat_FOR_EACH(_stat)			\
for (										\
	(_stat) = ADFS_Stat_FIRST_ONE;			\
	(_stat) < ADFS_Stat_NUMTYPES;			\
	(_stat) = ADFS_Stat_INC(_stat))

#define	ADFS_Stat_FOR_REVERSE(_stat)		\
for (										\
	;(_stat) > ADFS_Stat_NONE; 				\
	(_stat) = ADFS_Stat_DEC(_stat))

#define	ADFS_Stat_FOR_EACH_REVERSE(_stat)	\
	(_stat) = ADFS_Stat_LAST_ONE;			\
	ADFS_Stat_FOR_REVERSE(_stat)

/*************************************************************/
typedef enum {
	ADFS_DiskInfo_NONE, 
	
	ADFS_DiskInfo_TOTAL_ITEMS, 
	ADFS_DiskInfo_SPACE_USED, 
	ADFS_DiskInfo_SPACE_FREE, 

	ADFS_DiskInfo_NUMTYPES
} ADFS_DiskInfoType;

#define	ADFS_DiskInfo_INC(_info)	(ADFS_DiskInfoType)((_info) + 1)
#define	ADFS_DiskInfo_DEC(_info)	(ADFS_DiskInfoType)((_info) - 1)
#define	ADFS_DiskInfo_FIRST_ONE		ADFS_DiskInfo_INC(ADFS_DiskInfo_NONE)
#define	ADFS_DiskInfo_LAST_ONE		ADFS_DiskInfo_DEC(ADFS_DiskInfo_NUMTYPES)

#define	ADFS_DiskInfo_FOR_EACH(_info)			\
for (											\
	(_info) = ADFS_DiskInfo_FIRST_ONE;			\
	(_info) < ADFS_DiskInfo_NUMTYPES;	 		\
	(_info) = ADFS_DiskInfo_INC(_info))

#define	ADFS_DiskInfo_FOR_EACH_REVERSE(_info)	\
for (											\
	(_info) = ADFS_DiskInfo_LAST_ONE;			\
	(_info) > ADFS_DiskInfo_NONE; 				\
	(_info) = ADFS_DiskInfo_DEC(_info))

/*************************************************************/
typedef enum {
	ADFS_Justify_NONE, 
	
	ADFS_Justify_LEFT, 
	ADFS_Justify_MIDDLE, 
	ADFS_Justify_RIGHT,
	 
	ADFS_Justify_NUMTYPES
} ADFS_JustifyType;

/*************************************************************/
typedef unsigned char	ADFS_HeaderStr[20];

typedef struct {
	ADFS_HeaderStr		name;
	short				minWidth;
	short				width;
	short				border;	//	border is on the right
	ADFS_JustifyType	justify;
} ADFS_StatItem;

extern	ADFS_StatItem	gStats[];

/*************************************************************/
#define	ADFS_StatBorder		11
#define	ADFS_StatNoBorder	0


class	CFinderWindowHeader {
	
	public:	OSErr	IFinderWindowHeader(CFinderWindow *window);
	
			OSErr	InitStats(void);

	virtual	void	Dispose(void);
	
			void	Draw(void);
	virtual	void	GetStatSize(ADFS_StatType statType, short *left, short *right);
	virtual	void	SetNameExtra(short nameExtra);
			void	Flush(void);

	virtual	void	HitTest(
		Point			thePoint, 
		WindowRectType	*pane, 
		short			*subPane, 
		Rect			*hitRect);

	virtual	void	DoClick(
		Point			thePoint, 
		WindowRectType	pane, 
		short			subPane, 
		const Rect		*hitRect);

			short		GetStatBorder(ADFS_StatType statType);
	ADFS_JustifyType	GetStatJustify(ADFS_StatType statType);

	virtual	Boolean	DoCommand(long command);
	virtual	void	ShowStats(Boolean showStats);
		
	CFinderWindow	*i_window;

	ADFS_ViewAsType	i_viewAs;		//	list or icons
	ADFS_StatType	i_arrangeBy;	//	what column
	Boolean			i_reversedB;	//	ascend or descend?

	Boolean			i_showStats;
	short			i_nameExtra;
	Str255			i_tempString;
	ADFS_StatItem	i_stats[ADFS_Stat_NUMTYPES];
	ADFS_HeaderStr	i_diskInfos[ADFS_DiskInfo_NUMTYPES];
};

/*************************************************************/

#endif